Scriptname RF:SettingsScript Extends Quest

Actor PlayerRef

RF:FuelHandlerQuest Property RFQ Mandatory Const Auto

Group Settings
    GameplayOption Property _RF_GPO_MODE Mandatory Const Auto
    { This should be the main controller for all logic }
    GameplayOption Property _RF_GPO1 Mandatory Const Auto
    { Travel where 1 is easy mode }
    GameplayOption Property _RF_GPO2 Mandatory Const Auto
    { Verbosity where 1 is Verbose }
    GlobalVariable Property ModOnGlobal Const Auto
    { This can indicate mod state for other mods or scripts }
    GlobalVariable Property _RF_Sys_AllowTravel Mandatory Const Auto
    GlobalVariable Property _RF_Sys_Verbose Mandatory Const Auto
    Message Property DisableMSG Mandatory Const Auto
    { Displayed on transition to disabled }
    Message Property EnableMSG Mandatory Const Auto
    { Displayed on transition to enabled }
EndGroup

bool ModActive = true

;Handler for global & all perks
;aiDisabled must correspond to whichever GPO return value disables the main system
Function CheckSettings(int aiDisabled = 1)
    ;Wait until menu is closed to avoid clogging VM
    Utility.Wait(0.5)
    ;GPO as int, where 0 is enabled (as default)
    int ModToggle = _RF_GPO_MODE.GetValue() as int
    ;Display a message when changing state
    If ModActive && ModToggle == aiDisabled
        DisableMSG.Show()
    ElseIf !ModActive && ModToggle != aiDisabled
        EnableMSG.Show()
    EndIf
    ;Set our bool for the main state to reference elsewhere
    if ModToggle == 0
        ModActive = true
        ModOnGlobal.SetValue(1)
    Else
        ModActive = false
        ModOnGlobal.SetValue(0)
    EndIf
    ;Global so other scripts can reference if needed
    If ModOnGlobal
        ModOnGlobal.SetValue(ModActive as int)
    EndIf
    int Mode1 = _RF_GPO1.GetValue() as int
    int Mode2 = _RF_GPO2.GetValue() as int
    _RF_Sys_AllowTravel.SetValue(Mode1)
    _RF_Sys_Verbose.SetValue(Mode2)
    RFQ.HandleSettings()
EndFunction

Event OnQuestInit()
	StartTimer(5)
    GoToState("Starting")
EndEvent

State Starting
    Event OnTimer(int aiTimerID)
    	RegisterForGameplayOptionChangedEvent()
        CheckSettings()
        GotoState("")
    EndEvent
EndState

Event OnGameplayOptionChanged(GameplayOption[] aChangedOptions)
	CheckSettings()
EndEvent